#include <stdio.h>
#include <stdlib.h>
#include "../../../α㷨ʵ/01 /Status.h"

/* 궨 */
#define MAX 1000

/* Ͷ */
typedef struct Block
{
	int tag;					//0У1ռ 
	int cellsize;				//ĿС
	struct Block *next;			//ָһп
}Block;
typedef struct
{
	Block *lowbound;
	Block *highbound;
}Memory;

/* ȫֱ */
Memory Space;
Block *Heap;

/* ԭ */
void Algo_8_15();
void InitSpace();				//ʼڴռ
Block* MallocSpace(int n);		//СΪnڴ 
void FreeSpace(Block *p);		//pָڴ 
void PrintLayout();				//ڴռ 

int main(int argc, char *argv[])
{
	Block *p1, *p2, *p3, *p4, *p5, *p6;

	printf("ʼڴռ...\n");	
	InitSpace();
	PrintLayout();
	printf("\n");
	
	printf(" %d ڴ p1\n", 200); 
	p1 = MallocSpace(200);
	PrintLayout();	
	printf("\n");

	printf(" %d ڴ p2\n", 200); 		
	p2 = MallocSpace(200);
	PrintLayout();
	printf("\n");

	printf(" %d ڴ p3\n", 200); 			
	p3 = MallocSpace(200);
	PrintLayout();
	printf("\n");

	printf(" %d ڴ p4\n", 300); 				
	p4 = MallocSpace(300);
	PrintLayout();
	printf("\n");

	printf("մСΪ %d ڴ p1\n", 200);		
	FreeSpace(p1);
	PrintLayout();	
	printf("\n");

	printf("մСΪ %d ڴ p3\n", 200);			
	FreeSpace(p3);
	PrintLayout();	
	printf("\n");
	
	printf("ڴ棬Ƭ...\n");		
	Algo_8_15();
	PrintLayout();
	printf("\n");

	printf("մСΪ %d ڴ p5\n", 300);			
	p5 = MallocSpace(300);
	PrintLayout();	
	printf("\n");

	printf("մСΪ %d ڴ p2\n", 200);			
	FreeSpace(p2);
	PrintLayout();
	printf("\n");
		
	printf("մСΪ %d ڴ p6\n", 200);	
	p6 = MallocSpace(200);
	PrintLayout();
	printf("\n");

	printf("մСΪ %d ڴ p4\n", 300);			
	FreeSpace(p4);
	PrintLayout();
	printf("\n");

	printf("ڴ棬Ƭ...\n");			
	Algo_8_15();
	PrintLayout();
	printf("\n");
										
	return 0;
}

/*
8.15ڴթ
*/
void Algo_8_15()
{
	Block *p, *q;
	int count, k;
	
	for(p=Space.lowbound,count=0,Heap=NULL; p<=Space.highbound; p++)
	{
		if(p->tag==0)				//ƬδʹõĿռյһ 
		{
			count++;
			if(!Heap)
				Heap = q = p;
			else
			{
				q->next = p;
				q = q->next;			
			}
		}
	}
	
	q->next = NULL;
	Heap->cellsize = count;
}

void InitSpace()				//ʼڴռ
{
	Block *pre, *p;
	
	Space.lowbound = (Block *)malloc(MAX*sizeof(Block));
	Space.highbound = Space.lowbound + MAX - 1;
	
	Heap = Space.lowbound;
	Heap->cellsize = MAX;
	
	pre=Space.lowbound;
	pre->tag = 0;
	if(MAX>1)
	{
		for(p=pre+1; p<=Space.highbound; p++,pre++)
		{
			p->tag = 0;
			pre->next = p;
		}
	}
	pre->next = NULL;
}

Block* MallocSpace(int n)
{
	Block *p, *q;
	int count;
	
	if(!Heap || Heap->cellsize<n)		//ڴѲ 
		return NULL;
	
	p = q = Heap;
	
	for(count=1; count<n; count++)
	{
		q->tag = 1;
		q = q->next;
	}
	
	Heap = q->next;
	if(Heap)
		Heap->cellsize = p->cellsize - n;
	
	q->tag = 1;
	q->next = NULL;
	p->cellsize = n;
	
	return p;
}

void FreeSpace(Block *p)
{
	Block *r = p;
		
	while(r)
	{
		r->tag = 0;
		r = r->next; 
	}
}

void PrintLayout()
{
	int x, y, z, k;
	Block *p, *q;
	
	if(Heap)
		x = Heap->cellsize;				//ڴ 					
	else
		x = 0;
		
	for(p=Space.lowbound,y=0; p<=Space.highbound; p++)
	{
		if(p->tag==1)				//ͳƱռõڴ 
			y++;
	}
	
	z = MAX - x - y;				//ͳƬ
	
	printf("ÿռ %4dδÿռ %4dƬ %4dڴܿռ %4d\n", y, x, z, MAX);
}
